import { useState } from "react";
import { P2pWorkCard } from "./P2pWorkCard";
import { BsCashCoin } from "react-icons/bs";
import { FcDocument, FcMoneyTransfer } from "react-icons/fc";
import useTranslation from "next-translate/useTranslation";

export const P2pWork = ({ data }: any) => {
  const [buySellCrypto, setBuySellCrypto] = useState(true);
  const { t } = useTranslation("common");

  return (
    <div className=" tradex-pt-[85px] tradex-relative">
      <div className="tradex-bg-background-main tradex-rounded-lg tradex-border tradex-border-background-primary tradex-shadow-[2px_2px_23px_0px_#6C6C6C0D] tradex-px-6 tradex-py-4 md:tradex-px-20 md:tradex-py-10 tradex-space-y-12">
        <div className="tradex-max-w-[316px] tradex-mx-auto tradex-text-center tradex-space-y-5">
          <h3 className=" tradex-text-[24px] tradex-leading-[32px] md:tradex-text-[32px] md:tradex-leading-[48px] xl:tradex-text-[40px] xl:tradex-leading-[54px] !tradex-text-title">
            {t("How P2P works")}
          </h3>
          <div className=" tradex-flex tradex-items-center tradex-border tradex-border-background-primary tradex-rounded-sm tradex-w-fit tradex-mx-auto">
            <button
              onClick={() => setBuySellCrypto(true)}
              className={`${
                buySellCrypto
                  ? "tradex-text-white tradex-bg-primary"
                  : "tradex-text-body "
              } tradex-min-w-[112px] tradex-flex tradex-justify-center tradex-items-center tradex-p-1 tradex-rounded-sm tradex-min-h-[44px] tradex-text-base tradex-leading-[22px]`}
            >
              {t("Buy Crypto")}
            </button>
            <button
              className={`${
                !buySellCrypto
                  ? "tradex-text-white tradex-bg-primary"
                  : "tradex-text-body "
              } tradex-min-w-[112px] tradex-flex tradex-justify-center tradex-items-center tradex-p-1 tradex-rounded-sm tradex-min-h-[44px] tradex-text-base tradex-leading-[22px]`}
              onClick={() => setBuySellCrypto(false)}
            >
              {t("Sell Crypto")}
            </button>
          </div>
        </div>

        <div className=" tradex-grid tradex-justify-center md:tradex-justify-start md:tradex-grid-cols-3 tradex-gap-20 tradex-relative">
          {buySellCrypto === true ? (
            <>
              <P2pWorkCard
                title={data?.p2p_buy_step_1_heading}
                discription={data?.p2p_buy_step_1_des}
                icon={data?.p2p_buy_step_1_icon}
              />
              <span className=" tradex-hidden xl:tradex-block tradex-absolute tradex-top-10 tradex-left-[265px]">
                <svg
                  width="225"
                  height="10"
                  viewBox="0 0 225 10"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                  className=" tradex-fill-body"
                >
                  <path
                    d="M0 5C0 7.20914 1.79086 9 4 9C6.20914 9 8 7.20914 8 5C8 2.79086 6.20914 1 4 1C1.79086 1 0 2.79086 0 5ZM224.5 5L217 0.669873V9.33013L224.5 5ZM4 5.75H5.00227V4.25H4V5.75ZM7.00682 5.75H9.01136V4.25H7.00682V5.75ZM11.0159 5.75H13.0205V4.25H11.0159V5.75ZM15.025 5.75H17.0295V4.25H15.025V5.75ZM19.0341 5.75H21.0386V4.25H19.0341V5.75ZM23.0432 5.75H25.0477V4.25H23.0432V5.75ZM27.0523 5.75H29.0568V4.25H27.0523V5.75ZM31.0614 5.75H33.0659V4.25H31.0614V5.75ZM35.0705 5.75H37.075V4.25H35.0705V5.75ZM39.0795 5.75H41.0841V4.25H39.0795V5.75ZM43.0886 5.75H45.0932V4.25H43.0886V5.75ZM47.0977 5.75H49.1023V4.25H47.0977V5.75ZM51.1068 5.75H53.1114V4.25H51.1068V5.75ZM55.1159 5.75H57.1205V4.25H55.1159V5.75ZM59.125 5.75H61.1296V4.25H59.125V5.75ZM63.1341 5.75H65.1387V4.25H63.1341V5.75ZM67.1432 5.75H69.1478V4.25H67.1432V5.75ZM71.1523 5.75H73.1568V4.25H71.1523V5.75ZM75.1614 5.75H77.1659V4.25H75.1614V5.75ZM79.1705 5.75H81.175V4.25H79.1705V5.75ZM83.1796 5.75H85.1841V4.25H83.1796V5.75ZM87.1887 5.75H89.1932V4.25H87.1887V5.75ZM91.1978 5.75H93.2023V4.25H91.1978V5.75ZM95.2069 5.75H97.2114V4.25H95.2069V5.75ZM99.216 5.75H101.221V4.25H99.216V5.75ZM103.225 5.75H105.23V4.25H103.225V5.75ZM107.234 5.75H109.239V4.25H107.234V5.75ZM111.243 5.75H113.248V4.25H111.243V5.75ZM115.252 5.75H117.257V4.25H115.252V5.75ZM119.261 5.75H121.266V4.25H119.261V5.75ZM123.271 5.75H125.275V4.25H123.271V5.75ZM127.28 5.75H129.284V4.25H127.28V5.75ZM131.289 5.75H133.293V4.25H131.289V5.75ZM135.298 5.75H137.302V4.25H135.298V5.75ZM139.307 5.75H141.311V4.25H139.307V5.75ZM143.316 5.75H145.321V4.25H143.316V5.75ZM147.325 5.75H149.33V4.25H147.325V5.75ZM151.334 5.75H153.339V4.25H151.334V5.75ZM155.343 5.75H157.348V4.25H155.343V5.75ZM159.352 5.75H161.357V4.25H159.352V5.75ZM163.361 5.75H165.366V4.25H163.361V5.75ZM167.371 5.75H169.375V4.25H167.371V5.75ZM171.38 5.75H173.384V4.25H171.38V5.75ZM175.389 5.75H177.393V4.25H175.389V5.75ZM179.398 5.75H181.402V4.25H179.398V5.75ZM183.407 5.75H185.411V4.25H183.407V5.75ZM187.416 5.75H189.421V4.25H187.416V5.75ZM191.425 5.75H193.43V4.25H191.425V5.75ZM195.434 5.75H197.439V4.25H195.434V5.75ZM199.443 5.75H201.448V4.25H199.443V5.75ZM203.452 5.75H205.457V4.25H203.452V5.75ZM207.462 5.75H209.466V4.25H207.462V5.75ZM211.471 5.75H213.475V4.25H211.471V5.75ZM215.48 5.75H217.484V4.25H215.48V5.75ZM219.489 5.75H221.493V4.25H219.489V5.75Z"
                    fill="inherit"
                  />
                </svg>
              </span>
              <P2pWorkCard
                title={data?.p2p_buy_step_2_heading}
                discription={data?.p2p_buy_step_2_des}
                icon={data?.p2p_buy_step_2_icon}
              />
              <span className=" tradex-hidden xl:tradex-block tradex-absolute tradex-top-10 tradex-left-[665px]">
                <svg
                  width="225"
                  height="10"
                  viewBox="0 0 225 10"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                  className=" tradex-fill-body"
                >
                  <path
                    d="M0 5C0 7.20914 1.79086 9 4 9C6.20914 9 8 7.20914 8 5C8 2.79086 6.20914 1 4 1C1.79086 1 0 2.79086 0 5ZM224.5 5L217 0.669873V9.33013L224.5 5ZM4 5.75H5.00227V4.25H4V5.75ZM7.00682 5.75H9.01136V4.25H7.00682V5.75ZM11.0159 5.75H13.0205V4.25H11.0159V5.75ZM15.025 5.75H17.0295V4.25H15.025V5.75ZM19.0341 5.75H21.0386V4.25H19.0341V5.75ZM23.0432 5.75H25.0477V4.25H23.0432V5.75ZM27.0523 5.75H29.0568V4.25H27.0523V5.75ZM31.0614 5.75H33.0659V4.25H31.0614V5.75ZM35.0705 5.75H37.075V4.25H35.0705V5.75ZM39.0795 5.75H41.0841V4.25H39.0795V5.75ZM43.0886 5.75H45.0932V4.25H43.0886V5.75ZM47.0977 5.75H49.1023V4.25H47.0977V5.75ZM51.1068 5.75H53.1114V4.25H51.1068V5.75ZM55.1159 5.75H57.1205V4.25H55.1159V5.75ZM59.125 5.75H61.1296V4.25H59.125V5.75ZM63.1341 5.75H65.1387V4.25H63.1341V5.75ZM67.1432 5.75H69.1478V4.25H67.1432V5.75ZM71.1523 5.75H73.1568V4.25H71.1523V5.75ZM75.1614 5.75H77.1659V4.25H75.1614V5.75ZM79.1705 5.75H81.175V4.25H79.1705V5.75ZM83.1796 5.75H85.1841V4.25H83.1796V5.75ZM87.1887 5.75H89.1932V4.25H87.1887V5.75ZM91.1978 5.75H93.2023V4.25H91.1978V5.75ZM95.2069 5.75H97.2114V4.25H95.2069V5.75ZM99.216 5.75H101.221V4.25H99.216V5.75ZM103.225 5.75H105.23V4.25H103.225V5.75ZM107.234 5.75H109.239V4.25H107.234V5.75ZM111.243 5.75H113.248V4.25H111.243V5.75ZM115.252 5.75H117.257V4.25H115.252V5.75ZM119.261 5.75H121.266V4.25H119.261V5.75ZM123.271 5.75H125.275V4.25H123.271V5.75ZM127.28 5.75H129.284V4.25H127.28V5.75ZM131.289 5.75H133.293V4.25H131.289V5.75ZM135.298 5.75H137.302V4.25H135.298V5.75ZM139.307 5.75H141.311V4.25H139.307V5.75ZM143.316 5.75H145.321V4.25H143.316V5.75ZM147.325 5.75H149.33V4.25H147.325V5.75ZM151.334 5.75H153.339V4.25H151.334V5.75ZM155.343 5.75H157.348V4.25H155.343V5.75ZM159.352 5.75H161.357V4.25H159.352V5.75ZM163.361 5.75H165.366V4.25H163.361V5.75ZM167.371 5.75H169.375V4.25H167.371V5.75ZM171.38 5.75H173.384V4.25H171.38V5.75ZM175.389 5.75H177.393V4.25H175.389V5.75ZM179.398 5.75H181.402V4.25H179.398V5.75ZM183.407 5.75H185.411V4.25H183.407V5.75ZM187.416 5.75H189.421V4.25H187.416V5.75ZM191.425 5.75H193.43V4.25H191.425V5.75ZM195.434 5.75H197.439V4.25H195.434V5.75ZM199.443 5.75H201.448V4.25H199.443V5.75ZM203.452 5.75H205.457V4.25H203.452V5.75ZM207.462 5.75H209.466V4.25H207.462V5.75ZM211.471 5.75H213.475V4.25H211.471V5.75ZM215.48 5.75H217.484V4.25H215.48V5.75ZM219.489 5.75H221.493V4.25H219.489V5.75Z"
                    fill="inherit"
                  />
                </svg>
              </span>
              <P2pWorkCard
                title={data?.p2p_buy_step_3_heading}
                discription={data?.p2p_buy_step_3_des}
                icon={data?.p2p_buy_step_3_icon}
              />
            </>
          ) : (
            <>
              <P2pWorkCard
                title={data?.p2p_sell_step_1_heading}
                discription={data?.p2p_sell_step_1_des}
                icon={data?.p2p_sell_step_1_icon}
              />
              <span className=" tradex-hidden xl:tradex-block tradex-absolute tradex-top-10 tradex-left-[265px]">
                <svg
                  width="225"
                  height="10"
                  viewBox="0 0 225 10"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                  className=" tradex-fill-body"
                >
                  <path
                    d="M0 5C0 7.20914 1.79086 9 4 9C6.20914 9 8 7.20914 8 5C8 2.79086 6.20914 1 4 1C1.79086 1 0 2.79086 0 5ZM224.5 5L217 0.669873V9.33013L224.5 5ZM4 5.75H5.00227V4.25H4V5.75ZM7.00682 5.75H9.01136V4.25H7.00682V5.75ZM11.0159 5.75H13.0205V4.25H11.0159V5.75ZM15.025 5.75H17.0295V4.25H15.025V5.75ZM19.0341 5.75H21.0386V4.25H19.0341V5.75ZM23.0432 5.75H25.0477V4.25H23.0432V5.75ZM27.0523 5.75H29.0568V4.25H27.0523V5.75ZM31.0614 5.75H33.0659V4.25H31.0614V5.75ZM35.0705 5.75H37.075V4.25H35.0705V5.75ZM39.0795 5.75H41.0841V4.25H39.0795V5.75ZM43.0886 5.75H45.0932V4.25H43.0886V5.75ZM47.0977 5.75H49.1023V4.25H47.0977V5.75ZM51.1068 5.75H53.1114V4.25H51.1068V5.75ZM55.1159 5.75H57.1205V4.25H55.1159V5.75ZM59.125 5.75H61.1296V4.25H59.125V5.75ZM63.1341 5.75H65.1387V4.25H63.1341V5.75ZM67.1432 5.75H69.1478V4.25H67.1432V5.75ZM71.1523 5.75H73.1568V4.25H71.1523V5.75ZM75.1614 5.75H77.1659V4.25H75.1614V5.75ZM79.1705 5.75H81.175V4.25H79.1705V5.75ZM83.1796 5.75H85.1841V4.25H83.1796V5.75ZM87.1887 5.75H89.1932V4.25H87.1887V5.75ZM91.1978 5.75H93.2023V4.25H91.1978V5.75ZM95.2069 5.75H97.2114V4.25H95.2069V5.75ZM99.216 5.75H101.221V4.25H99.216V5.75ZM103.225 5.75H105.23V4.25H103.225V5.75ZM107.234 5.75H109.239V4.25H107.234V5.75ZM111.243 5.75H113.248V4.25H111.243V5.75ZM115.252 5.75H117.257V4.25H115.252V5.75ZM119.261 5.75H121.266V4.25H119.261V5.75ZM123.271 5.75H125.275V4.25H123.271V5.75ZM127.28 5.75H129.284V4.25H127.28V5.75ZM131.289 5.75H133.293V4.25H131.289V5.75ZM135.298 5.75H137.302V4.25H135.298V5.75ZM139.307 5.75H141.311V4.25H139.307V5.75ZM143.316 5.75H145.321V4.25H143.316V5.75ZM147.325 5.75H149.33V4.25H147.325V5.75ZM151.334 5.75H153.339V4.25H151.334V5.75ZM155.343 5.75H157.348V4.25H155.343V5.75ZM159.352 5.75H161.357V4.25H159.352V5.75ZM163.361 5.75H165.366V4.25H163.361V5.75ZM167.371 5.75H169.375V4.25H167.371V5.75ZM171.38 5.75H173.384V4.25H171.38V5.75ZM175.389 5.75H177.393V4.25H175.389V5.75ZM179.398 5.75H181.402V4.25H179.398V5.75ZM183.407 5.75H185.411V4.25H183.407V5.75ZM187.416 5.75H189.421V4.25H187.416V5.75ZM191.425 5.75H193.43V4.25H191.425V5.75ZM195.434 5.75H197.439V4.25H195.434V5.75ZM199.443 5.75H201.448V4.25H199.443V5.75ZM203.452 5.75H205.457V4.25H203.452V5.75ZM207.462 5.75H209.466V4.25H207.462V5.75ZM211.471 5.75H213.475V4.25H211.471V5.75ZM215.48 5.75H217.484V4.25H215.48V5.75ZM219.489 5.75H221.493V4.25H219.489V5.75Z"
                    fill="inherit"
                  />
                </svg>
              </span>
              <P2pWorkCard
                title={data?.p2p_sell_step_2_heading}
                discription={data?.p2p_sell_step_2_des}
                icon={data?.p2p_sell_step_2_icon}
              />
              <span className=" tradex-hidden xl:tradex-block tradex-absolute tradex-top-10 tradex-left-[665px]">
                <svg
                  width="225"
                  height="10"
                  viewBox="0 0 225 10"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                  className=" tradex-fill-body"
                >
                  <path
                    d="M0 5C0 7.20914 1.79086 9 4 9C6.20914 9 8 7.20914 8 5C8 2.79086 6.20914 1 4 1C1.79086 1 0 2.79086 0 5ZM224.5 5L217 0.669873V9.33013L224.5 5ZM4 5.75H5.00227V4.25H4V5.75ZM7.00682 5.75H9.01136V4.25H7.00682V5.75ZM11.0159 5.75H13.0205V4.25H11.0159V5.75ZM15.025 5.75H17.0295V4.25H15.025V5.75ZM19.0341 5.75H21.0386V4.25H19.0341V5.75ZM23.0432 5.75H25.0477V4.25H23.0432V5.75ZM27.0523 5.75H29.0568V4.25H27.0523V5.75ZM31.0614 5.75H33.0659V4.25H31.0614V5.75ZM35.0705 5.75H37.075V4.25H35.0705V5.75ZM39.0795 5.75H41.0841V4.25H39.0795V5.75ZM43.0886 5.75H45.0932V4.25H43.0886V5.75ZM47.0977 5.75H49.1023V4.25H47.0977V5.75ZM51.1068 5.75H53.1114V4.25H51.1068V5.75ZM55.1159 5.75H57.1205V4.25H55.1159V5.75ZM59.125 5.75H61.1296V4.25H59.125V5.75ZM63.1341 5.75H65.1387V4.25H63.1341V5.75ZM67.1432 5.75H69.1478V4.25H67.1432V5.75ZM71.1523 5.75H73.1568V4.25H71.1523V5.75ZM75.1614 5.75H77.1659V4.25H75.1614V5.75ZM79.1705 5.75H81.175V4.25H79.1705V5.75ZM83.1796 5.75H85.1841V4.25H83.1796V5.75ZM87.1887 5.75H89.1932V4.25H87.1887V5.75ZM91.1978 5.75H93.2023V4.25H91.1978V5.75ZM95.2069 5.75H97.2114V4.25H95.2069V5.75ZM99.216 5.75H101.221V4.25H99.216V5.75ZM103.225 5.75H105.23V4.25H103.225V5.75ZM107.234 5.75H109.239V4.25H107.234V5.75ZM111.243 5.75H113.248V4.25H111.243V5.75ZM115.252 5.75H117.257V4.25H115.252V5.75ZM119.261 5.75H121.266V4.25H119.261V5.75ZM123.271 5.75H125.275V4.25H123.271V5.75ZM127.28 5.75H129.284V4.25H127.28V5.75ZM131.289 5.75H133.293V4.25H131.289V5.75ZM135.298 5.75H137.302V4.25H135.298V5.75ZM139.307 5.75H141.311V4.25H139.307V5.75ZM143.316 5.75H145.321V4.25H143.316V5.75ZM147.325 5.75H149.33V4.25H147.325V5.75ZM151.334 5.75H153.339V4.25H151.334V5.75ZM155.343 5.75H157.348V4.25H155.343V5.75ZM159.352 5.75H161.357V4.25H159.352V5.75ZM163.361 5.75H165.366V4.25H163.361V5.75ZM167.371 5.75H169.375V4.25H167.371V5.75ZM171.38 5.75H173.384V4.25H171.38V5.75ZM175.389 5.75H177.393V4.25H175.389V5.75ZM179.398 5.75H181.402V4.25H179.398V5.75ZM183.407 5.75H185.411V4.25H183.407V5.75ZM187.416 5.75H189.421V4.25H187.416V5.75ZM191.425 5.75H193.43V4.25H191.425V5.75ZM195.434 5.75H197.439V4.25H195.434V5.75ZM199.443 5.75H201.448V4.25H199.443V5.75ZM203.452 5.75H205.457V4.25H203.452V5.75ZM207.462 5.75H209.466V4.25H207.462V5.75ZM211.471 5.75H213.475V4.25H211.471V5.75ZM215.48 5.75H217.484V4.25H215.48V5.75ZM219.489 5.75H221.493V4.25H219.489V5.75Z"
                    fill="inherit"
                  />
                </svg>
              </span>
              <P2pWorkCard
                title={data?.p2p_sell_step_3_heading}
                discription={data?.p2p_sell_step_3_des}
                icon={data?.p2p_sell_step_3_icon}
              />
            </>
          )}
        </div>
      </div>
      <span className=" tradex-absolute -tradex-bottom-[28px] -tradex-right-[28px] -tradex-z-[1]">
        <svg
          width="129"
          height="95"
          viewBox="0 0 129 95"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
          className=" tradex-fill-primary"
        >
          <g opacity="0.5">
            <path
              d="M84.8056 22.2764C83.171 22.2764 81.7407 23.6045 81.7407 25.3413C81.7407 26.9759 83.0688 28.4061 84.8056 28.4061C86.4402 28.4061 87.8704 27.078 87.8704 25.3413C87.7683 23.6045 86.4402 22.2764 84.8056 22.2764Z"
              fill="inherit"
            />
            <path
              d="M84.8056 0C83.171 0 81.7407 1.3281 81.7407 3.06486C81.7407 4.69945 83.0688 6.12971 84.8056 6.12971C86.4402 6.12971 87.8704 4.80161 87.8704 3.06486C87.7683 1.3281 86.4402 0 84.8056 0Z"
              fill="inherit"
            />
            <path
              d="M105.235 22.2764C103.601 22.2764 102.17 23.6045 102.17 25.3413C102.17 26.9759 103.498 28.4061 105.235 28.4061C106.87 28.4061 108.3 27.078 108.3 25.3413C108.198 23.6045 106.87 22.2764 105.235 22.2764Z"
              fill="inherit"
            />
            <path
              d="M105.235 0C103.601 0 102.17 1.3281 102.17 3.06486C102.17 4.69945 103.498 6.12971 105.235 6.12971C106.87 6.12971 108.3 4.80161 108.3 3.06486C108.198 1.3281 106.87 0 105.235 0Z"
              fill="inherit"
            />
            <path
              d="M125.665 22.2764C124.03 22.2764 122.6 23.6045 122.6 25.3413C122.6 26.9759 123.928 28.4061 125.665 28.4061C127.299 28.4061 128.73 27.078 128.73 25.3413C128.73 23.6045 127.299 22.2764 125.665 22.2764Z"
              fill="inherit"
            />
            <path
              d="M125.665 0C124.03 0 122.6 1.3281 122.6 3.06486C122.6 4.69945 123.928 6.12971 125.665 6.12971C127.299 6.12971 128.73 4.80161 128.73 3.06486C128.73 1.3281 127.299 0 125.665 0Z"
              fill="inherit"
            />
            <path
              d="M84.8056 88.8716C83.171 88.8716 81.7407 90.1997 81.7407 91.9364C81.7407 93.571 83.0688 95.0013 84.8056 95.0013C86.4402 95.0013 87.8704 93.6732 87.8704 91.9364C87.7683 90.1997 86.4402 88.8716 84.8056 88.8716Z"
              fill="inherit"
            />
            <path
              d="M84.8056 66.5952C83.171 66.5952 81.7407 67.9233 81.7407 69.66C81.7407 71.2946 83.0688 72.7249 84.8056 72.7249C86.4402 72.7249 87.8704 71.3968 87.8704 69.66C87.7683 68.0254 86.4402 66.5952 84.8056 66.5952Z"
              fill="inherit"
            />
            <path
              d="M84.8056 44.4468C83.171 44.4468 81.7407 45.7749 81.7407 47.5117C81.7407 49.1463 83.0688 50.5766 84.8056 50.5766C86.4402 50.5766 87.8704 49.2484 87.8704 47.5117C87.7683 45.7749 86.4402 44.4468 84.8056 44.4468Z"
              fill="inherit"
            />
            <path
              d="M105.235 88.8716C103.601 88.8716 102.17 90.1997 102.17 91.9364C102.17 93.571 103.498 95.0013 105.235 95.0013C106.87 95.0013 108.3 93.6732 108.3 91.9364C108.198 90.1997 106.87 88.8716 105.235 88.8716Z"
              fill="inherit"
            />
            <path
              d="M105.235 66.5952C103.601 66.5952 102.17 67.9233 102.17 69.66C102.17 71.2946 103.498 72.7249 105.235 72.7249C106.87 72.7249 108.3 71.3968 108.3 69.66C108.198 68.0254 106.87 66.5952 105.235 66.5952Z"
              fill="inherit"
            />
            <path
              d="M105.235 44.4468C103.601 44.4468 102.17 45.7749 102.17 47.5117C102.17 49.1463 103.498 50.5766 105.235 50.5766C106.87 50.5766 108.3 49.2484 108.3 47.5117C108.198 45.7749 106.87 44.4468 105.235 44.4468Z"
              fill="inherit"
            />
            <path
              d="M125.665 88.8716C124.03 88.8716 122.6 90.1997 122.6 91.9364C122.6 93.571 123.928 95.0013 125.665 95.0013C127.299 95.0013 128.73 93.6732 128.73 91.9364C128.73 90.1997 127.299 88.8716 125.665 88.8716Z"
              fill="inherit"
            />
            <path
              d="M125.665 66.5952C124.03 66.5952 122.6 67.9233 122.6 69.66C122.6 71.2946 123.928 72.7249 125.665 72.7249C127.299 72.7249 128.73 71.3968 128.73 69.66C128.73 68.0254 127.299 66.5952 125.665 66.5952Z"
              fill="inherit"
            />
            <path
              d="M125.665 44.4468C124.03 44.4468 122.6 45.7749 122.6 47.5117C122.6 49.1463 123.928 50.5766 125.665 50.5766C127.299 50.5766 128.73 49.2484 128.73 47.5117C128.73 45.7749 127.299 44.4468 125.665 44.4468Z"
              fill="inherit"
            />
            <path
              d="M3.06486 22.2764C1.43027 22.2764 0 23.6045 0 25.3413C0 26.9759 1.3281 28.4061 3.06486 28.4061C4.69945 28.4061 6.12971 27.078 6.12971 25.3413C6.12971 23.6045 4.80161 22.2764 3.06486 22.2764Z"
              fill="inherit"
            />
            <path
              d="M3.06486 0C1.43027 0 0 1.3281 0 3.06486C0 4.69945 1.3281 6.12971 3.06486 6.12971C4.69945 6.12971 6.12971 4.80161 6.12971 3.06486C6.12971 1.3281 4.80161 0 3.06486 0Z"
              fill="inherit"
            />
            <path
              d="M23.4945 22.2764C21.8599 22.2764 20.4296 23.6045 20.4296 25.3413C20.4296 26.9759 21.7577 28.4061 23.4945 28.4061C25.1291 28.4061 26.5593 27.078 26.5593 25.3413C26.5593 23.6045 25.2312 22.2764 23.4945 22.2764Z"
              fill="inherit"
            />
            <path
              d="M23.4945 0C21.8599 0 20.4296 1.3281 20.4296 3.06486C20.4296 4.69945 21.7577 6.12971 23.4945 6.12971C25.1291 6.12971 26.5593 4.80161 26.5593 3.06486C26.5593 1.3281 25.2312 0 23.4945 0Z"
              fill="inherit"
            />
            <path
              d="M43.9242 22.2764C42.2896 22.2764 40.8593 23.6045 40.8593 25.3413C40.8593 26.9759 42.1874 28.4061 43.9242 28.4061C45.5588 28.4061 46.989 27.078 46.989 25.3413C46.989 23.6045 45.6609 22.2764 43.9242 22.2764Z"
              fill="inherit"
            />
            <path
              d="M43.9242 0C42.2896 0 40.8593 1.3281 40.8593 3.06486C40.8593 4.69945 42.1874 6.12971 43.9242 6.12971C45.5588 6.12971 46.989 4.80161 46.989 3.06486C46.989 1.3281 45.6609 0 43.9242 0Z"
              fill="inherit"
            />
            <path
              d="M66.9078 23.6045C66.7035 23.298 66.397 22.9916 66.0906 22.7872C65.5797 22.4808 65.0689 22.2764 64.3538 22.2764C63.9451 22.2764 63.5365 22.3786 63.1279 22.4808C62.7192 22.6851 62.4127 22.8894 62.2084 23.0937C61.6976 23.6045 61.2889 24.4218 61.2889 25.2391C61.2889 26.0564 61.5954 26.8737 62.2084 27.3845C62.5149 27.691 62.8214 27.8953 63.1279 27.9975C63.5365 28.2018 63.843 28.2018 64.3538 28.2018C64.9668 28.2018 65.5797 27.9975 66.0906 27.691C66.397 27.4867 66.7035 27.1802 66.9078 26.8737C67.1122 26.5672 67.3165 26.1586 67.3165 25.7499C67.3165 25.5456 67.4187 25.3413 67.4187 25.137C67.4187 24.9326 67.4187 24.7283 67.3165 24.524C67.3165 24.2175 67.1122 23.911 66.9078 23.6045Z"
              fill="inherit"
            />
            <path
              d="M66.9078 1.32809C66.7035 1.02161 66.397 0.715133 66.0906 0.510809C65.5797 0.204324 65.0689 0 64.3538 0C63.9451 0 63.5365 0.102174 63.1279 0.204336C62.7192 0.40866 62.4127 0.612959 62.2084 0.817283C61.6976 1.32809 61.2889 2.14542 61.2889 2.96271C61.2889 3.78001 61.5954 4.59728 62.2084 5.10809C62.5149 5.41458 62.8214 5.61894 63.1279 5.72111C63.5365 5.92543 63.843 5.92538 64.3538 5.92538C64.9668 5.92538 65.5797 5.72106 66.0906 5.41457C66.397 5.21025 66.7035 4.90377 66.9078 4.59728C67.1122 4.2908 67.3165 3.88217 67.3165 3.47352C67.3165 3.2692 67.4187 3.06485 67.4187 2.86052C67.4187 2.6562 67.4187 2.4519 67.3165 2.24757C67.3165 2.04325 67.1122 1.63458 66.9078 1.32809Z"
              fill="inherit"
            />
            <path
              d="M3.06486 88.8716C1.43027 88.8716 0 90.1997 0 91.9364C0 93.571 1.3281 95.0013 3.06486 95.0013C4.69945 95.0013 6.12971 93.6732 6.12971 91.9364C6.12971 90.1997 4.80161 88.8716 3.06486 88.8716Z"
              fill="inherit"
            />
            <path
              d="M3.06486 66.5952C1.43027 66.5952 0 67.9233 0 69.66C0 71.2946 1.3281 72.7249 3.06486 72.7249C4.69945 72.7249 6.12971 71.3968 6.12971 69.66C6.12971 68.0254 4.80161 66.5952 3.06486 66.5952Z"
              fill="inherit"
            />
            <path
              d="M3.06486 44.4468C1.43027 44.4468 0 45.7749 0 47.5117C0 49.1463 1.3281 50.5766 3.06486 50.5766C4.69945 50.5766 6.12971 49.2484 6.12971 47.5117C6.12971 45.7749 4.80161 44.4468 3.06486 44.4468Z"
              fill="inherit"
            />
            <path
              d="M23.4945 88.8716C21.8599 88.8716 20.4296 90.1997 20.4296 91.9364C20.4296 93.571 21.7577 95.0013 23.4945 95.0013C25.1291 95.0013 26.5593 93.6732 26.5593 91.9364C26.5593 90.1997 25.2312 88.8716 23.4945 88.8716Z"
              fill="inherit"
            />
            <path
              d="M23.4945 66.5952C21.8599 66.5952 20.4296 67.9233 20.4296 69.66C20.4296 71.2946 21.7577 72.7249 23.4945 72.7249C25.1291 72.7249 26.5593 71.3968 26.5593 69.66C26.5593 68.0254 25.2312 66.5952 23.4945 66.5952Z"
              fill="inherit"
            />
            <path
              d="M23.4945 44.4468C21.8599 44.4468 20.4296 45.7749 20.4296 47.5117C20.4296 49.1463 21.7577 50.5766 23.4945 50.5766C25.1291 50.5766 26.5593 49.2484 26.5593 47.5117C26.5593 45.7749 25.2312 44.4468 23.4945 44.4468Z"
              fill="inherit"
            />
            <path
              d="M43.9242 88.8716C42.2896 88.8716 40.8593 90.1997 40.8593 91.9364C40.8593 93.571 42.1874 95.0013 43.9242 95.0013C45.5588 95.0013 46.989 93.6732 46.989 91.9364C46.989 90.1997 45.6609 88.8716 43.9242 88.8716Z"
              fill="inherit"
            />
            <path
              d="M43.9242 66.5952C42.2896 66.5952 40.8593 67.9233 40.8593 69.66C40.8593 71.2946 42.1874 72.7249 43.9242 72.7249C45.5588 72.7249 46.989 71.3968 46.989 69.66C46.989 68.0254 45.6609 66.5952 43.9242 66.5952Z"
              fill="inherit"
            />
            <path
              d="M43.9242 44.4468C42.2896 44.4468 40.8593 45.7749 40.8593 47.5117C40.8593 49.1463 42.1874 50.5766 43.9242 50.5766C45.5588 50.5766 46.989 49.2484 46.989 47.5117C46.989 45.7749 45.6609 44.4468 43.9242 44.4468Z"
              fill="inherit"
            />
            <path
              d="M66.9078 90.1997C66.7035 89.8932 66.397 89.5867 66.0906 89.3824C65.5797 89.0759 65.0689 88.8716 64.3538 88.8716C63.9451 88.8716 63.5365 88.9737 63.1279 89.0759C62.7192 89.2802 62.4127 89.4846 62.2084 89.6889C61.6976 90.1997 61.2889 91.017 61.2889 91.8343C61.2889 92.6516 61.5954 93.4689 62.2084 93.9797C62.5149 94.2862 62.8214 94.4905 63.1279 94.5926C63.5365 94.6948 63.843 94.797 64.3538 94.797C64.9668 94.797 65.5797 94.5926 66.0906 94.2862C66.397 94.0818 66.7035 93.7754 66.9078 93.4689C67.1122 93.1624 67.3165 92.7537 67.3165 92.3451C67.3165 92.1408 67.4187 91.9364 67.4187 91.7321C67.4187 91.5278 67.4187 91.3235 67.3165 91.1191C67.3165 90.8127 67.1122 90.5062 66.9078 90.1997Z"
              fill="inherit"
            />
            <path
              d="M66.9078 67.9233C66.7035 67.6168 66.397 67.3103 66.0906 67.106C65.5797 66.7995 65.0689 66.5952 64.3538 66.5952C63.9451 66.5952 63.5365 66.6973 63.1279 66.7995C62.7192 67.0038 62.4127 67.2081 62.2084 67.4125C61.6976 67.9233 61.2889 68.7406 61.2889 69.5578C61.2889 70.3751 61.5954 71.1924 62.2084 71.7032C62.5149 72.0097 62.8214 72.2141 63.1279 72.3162C63.5365 72.4184 63.843 72.5205 64.3538 72.5205C64.9668 72.5205 65.5797 72.3162 66.0906 72.0097C66.397 71.8054 66.7035 71.4989 66.9078 71.1924C67.1122 70.886 67.3165 70.4773 67.3165 70.0687C67.3165 69.8643 67.4187 69.66 67.4187 69.4557C67.4187 69.2514 67.4187 69.047 67.3165 68.8427C67.3165 68.6384 67.1122 68.2297 66.9078 67.9233Z"
              fill="inherit"
            />
            <path
              d="M66.9078 45.7749C66.7035 45.4685 66.397 45.162 66.0906 44.9576C65.5797 44.6512 65.0689 44.4468 64.3538 44.4468C63.9451 44.4468 63.5365 44.549 63.1279 44.6512C62.7192 44.7533 62.4127 45.0598 62.2084 45.2641C61.6976 45.7749 61.2889 46.5922 61.2889 47.4095C61.2889 48.2268 61.5954 49.0441 62.2084 49.5549C62.5149 49.8614 62.8214 50.0657 63.1279 50.1679C63.5365 50.3722 63.843 50.3722 64.3538 50.3722C64.9668 50.3722 65.5797 50.1679 66.0906 49.8614C66.397 49.6571 66.7035 49.3506 66.9078 49.0441C67.1122 48.7376 67.3165 48.329 67.3165 47.9203C67.3165 47.716 67.4187 47.5117 67.4187 47.3074C67.4187 47.103 67.4187 46.8987 67.3165 46.6944C67.3165 46.4901 67.1122 46.0814 66.9078 45.7749Z"
              fill="inherit"
            />
          </g>
        </svg>
      </span>
    </div>
  );
};
